module univ_shift_reg
    #(parameter N=8)
    (
    input clk,
    input reset,
    input [1:0] ctrl,
    input [N-1:0] d,
    output [N-1:0] q
    );
    (* keep = "true" *) reg [N-1:0] r_reg, r_next;
    // registros
    always @(posedge clk, posedge reset)
        if (reset)
            r_reg <= 0;
        else
            r_reg <= r_next;
    // logica de siguiente estado
    always @*
        case (ctrl)
            2'b00: r_next = r_reg; // no hacer nada
            2'b01: r_next = {r_reg[N-2:0], d[0]}; // desp. izquierda
            2'b10: r_next = {d[N-1], r_reg[N-1:1]}; // desp. derecha
            default: r_next = d; // carga paralela
        endcase
    // logica de salida
    assign q = r_reg;
endmodule





