module univ_bin_counter
    #(parameter N=8)
    (
    input clk, reset, syn_clr, load, en, up,
    input [N-1:0]d,
    output max, cero,
    output [N-1:0] q
    );
    reg [N-1:0] r_reg, r_next;
    // FF
    always @(posedge clk, posedge reset)
        if (reset)
            r_reg <= 0;
        else
            r_reg <= r_next;
    // logica de siguiente estado
    // if anidado para las prioridades 
    // de seales de control
    always @*
        if (syn_clr) // puesta a cero
            r_next = 0;
        else
            if (load) // carga de valor
                r_next = d;
            else
                if (en & up) // conteo ascendente
                    r_next = r_reg + 1;
                else
                    if (en & -up) // conteo descendente
                        r_next = r_reg - 1;
                    else
                        r_next = r_reg; // pausa
     // logica de salida
     assign q = r_reg;
     assign max = (r_reg == 2**N-1) ? 1'b1 : 1'b0;
     assign cero = (r_reg == 0) ? 1'b1 : 1'b0;
endmodule



