module prio_encoder_casez(
    input wire [3:0] r,
    output reg [2:0] y
    );
    always @*
        casez (r)
            4'b1???:
                y = 3'b100; // r = 1XXX
            4'b01??:
                y = 3'b011; // r = 01XX
            4'b001?:
                y = 3'b010; // r = 001X
            4'b0001:
                y = 3'b001; // r = 0001
            4'b0000: // tambien podria usarse default
                y = 3'b000; // r = 0000  
        endcase              
endmodule








//module prio_encoder_case(
//    input wire [3:0] r,
//    output reg [2:0] y
//    );
//    always @*
//        case (r)
//            4'b1000, 4'b1001, 4'b1010, 4'b1011,
//            4'b1100, 4'b1101, 4'b1110, 4'b1111:
//                y = 3'b100; // r = 1XXX
//            4'b0100, 4'b0101, 4'b0110, 4'b0111:
//                y = 3'b011; // r = 01XX
//            4'b0010, 4'b0011:
//                y = 3'b010; // r = 001X
//            4'b0001:
//                y = 3'b001; // r = 0001
//            default: // tambien podria usarse 4'b0000
//                y = 3'b000; // r = 0000  
//        endcase              
//endmodule

