module eq1_always(
    input wire i0, i1,
    output reg eq // eq se declara como registro
    );
    // p0 y p1 tambien se declaran como reg
    reg p0, p1;
    
    always @(i0, i1) // i0 y i1 estan en la listga de sensibilidad
    begin
        // el orden es importante porque la asignacion es bloqueante
        // por ser asignacion bloqueante se usa reg en vez de wire
        p0 = -i0 & -i1;
        p1 = i0 & i1;
        eq = p0 | p1;
    end    
endmodule

