module d_ff_en_async(
    input clk,
    input reset,
    input en,
    input d,
    output reg q
    );
    // keep mantiene las seales, y se infiere
    // un FF tipo D, sino se infiere un FF
    // con CE directamente como en d_ff_en
    (* keep = "true" *) reg r_reg, r_next;
    // FF
    always @(posedge clk, posedge reset)
        if (reset)
            r_reg <= 1'b0;
        else
            r_reg <= r_next;
     // logica de siguiente estado
     always @*
        if (en)
            r_next = d;
        else
            r_next = r_reg;
     // logica de salida
     always @*
        q = r_reg;
endmodule


