module adder_carry_param
    #(parameter N=4) // sumador de 4 bits por defecto
    (
        input wire [N-1:0] a, b,
        output wire [N-1:0] sum,
        output wire cout
    );
    localparam N1 = N-1; // parametro local con la cantidad de bits menos uno para indice 
    wire [N:0] sum_ext; // seal interna extendida con un bit para carry
    assign sum_ext = {1'b0, a} + {1'b0, b}; // realizo la suma extendida con 0 para guardar el carry
    assign sum = sum_ext[N1:0]; // el resultado en la cantidad de bits del parametro
    assign cout = sum_ext[N]; // el MSB es el carry
endmodule

